IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].UFD_STRING_SPLIT') AND TYPE IN (N'FN', N'IF', N'TF', N'FS', N'FT'))
    DROP FUNCTION [DBO].UFD_STRING_SPLIT
GO 

CREATE FUNCTION UFD_STRING_SPLIT
( 
 @Input NVARCHAR(MAX),
 @Character CHAR(1)
)
RETURNS @Output TABLE (
 Item NVARCHAR(1000)
)
AS
BEGIN
 DECLARE @StartIndex INT, @EndIndex INT
 
 SET @StartIndex = 1
 IF SUBSTRING(@Input, LEN(@Input) - 1, LEN(@Input)) <> @Character
 BEGIN
 SET @Input = @Input + @Character
 END
 
 WHILE CHARINDEX(@Character, @Input) > 0
 BEGIN
 SET @EndIndex = CHARINDEX(@Character, @Input)
 
 INSERT INTO @Output(Item)
 SELECT SUBSTRING(@Input, @StartIndex, @EndIndex - 1)
 
 SET @Input = SUBSTRING(@Input, @EndIndex + 1, LEN(@Input))
 END
 
 RETURN
END